//공지사항
let noticeUids = [];

let readNoticeList = (JSON.parse(localStorage.getItem('readNoticeList')) || []),
selfDeletedNoticeList = (JSON.parse(localStorage.getItem('selfDeletedNoticeList')) || []);

function getNoticesUids(){
    var tempUrl = server_host + server_port + '/astroapi/notice/v1/notices/all';

    cordova.plugin.http.get(tempUrl, {}, {
        Authorization: 'Bearer ' + window.localStorage.getArray("userData").astroToken
    }, function (response) {
        var jsonData = JSON.parse(response.data);

        noticeUids = jsonData.data.map(function(notice) {
            return notice.uid;
        });

        updateNewNoticeIndicator();

    }, function (response) {
        // prints 403
        popAlert("오류가 발생했습니다.<br/>잠시 후 다시 시도해 주세요");
    });
}

function updateNewNoticeIndicator() { 
    var unreadNoticeCount = 0;
    for (var i = 0; i < noticeUids.length; i++) {
        if (!readNoticeList.includes(noticeUids[i])) { 
            unreadNoticeCount++;
        }
    }

    if (unreadNoticeCount > 0) {
        // 읽지 않은 공지사항이 있는 경우
        $(".new").show(); 
    } else {
        $(".new").hide(); 
    }
}

// 공지사항 불러오기 함수
function getNotices(tabId) {
    // 선택된 탭의 ID에 따라 필터링할 카테고리 설정
    let categoryFilter = "";
    if (tabId === "#tab02") {
        categoryFilter = "E";
    } else if (tabId === "#tab03") {
        categoryFilter = "N";
    }

    let alarmValue = $("#alarmSelect").val();

    // 셀렉트 박스 값에 따라 필터 설정
    let alarmFilter = "";
    if (alarmValue === "Y") {
        alarmFilter = "Y";
    } else if (alarmValue === "N") {
        alarmFilter = "N";
    }

    let tempUrl = server_host + server_port + '/astroapi/notice/v1/notices/all';

    cordova.plugin.http.get(tempUrl, {}, {
        Authorization: 'Bearer ' + userData.astroToken
    }, function (response) {
        let jsonData = JSON.parse(response.data);
       
        allNotices = jsonData;
        // 내림차순으로 정렬
        jsonData.data.sort(function(a, b) {
            return b.uid - a.uid;
        });

        // 필터링된 공지사항 데이터를 가져오기
        let filteredNotices = filterNoticesByAlarm(jsonData.data, alarmFilter);

        // 필터링된 공지사항 데이터를 받아와서 HTML에 추가하는 함수 호출
        addFilteredNoticesToHTML(filteredNotices, categoryFilter);

        if($('#notice_srch_keyword').val() != ''){
            $('#notice_srch_keyword').trigger('keyup');
        }
        $(".notice_pop").stop().show(); // 공지사항을 불러온 후 팝업 열기

        // 읽은 공지사항 처리
        markReadNotices(filteredNotices);

        // jsonData에서 공지사항의 uid 추출
        let jsonDataUids = jsonData.data.map(function(notice) {
            return notice.uid;
        });

        // readNoticeList에는 있지만 jsonData에는 없는 uid 삭제
        readNoticeList = readNoticeList.filter(function(uid) {
            return jsonDataUids.includes(uid);
        });

        localStorage.setItem('readNoticeList', JSON.stringify(readNoticeList));

    }, function (response) {
        // prints 403
        console.log('readAllNotices',"공지사항 불러오기 실패 response status:" + JSON.stringify(response));
        console.log('readAllNotices',response.error);
        popAlert("공지사항 불러오기 실패 오류가 발생했습니다.<br/>잠시 후 다시 시도해 주세요");
    });
};

// 모든 공지를 읽은 것으로 표시하는 함수   
function readAllNotices() {
    // 모든 공지 읽은 것으로 처리
    $(".new").removeClass("new");
    readNoticeList = [];

    allNotices.data.forEach(item => {
        readNoticeList.push(item.uid);
    });

    localStorage.setItem('readNoticeList', JSON.stringify(readNoticeList));

    // 리스트 갱신
    getNotices("#tab01");
    $(".new").remove(); // 새로고침 후 모든 새로운 표시 제거
}

// deleteAll 버튼 클릭 시 실행되는 함수
function deleteAllNotices() {
    // 모든 공지를 읽은 것으로 처리
    $(".new").removeClass("new");

    // selfDeletedNoticeList에 모든 공지를 추가하여 해당 공지를 삭제했음을 표시
    allNotices.data.forEach(item => {
        let uid = item.uid;
        if (!selfDeletedNoticeList.includes(uid)) {
            selfDeletedNoticeList.push(uid);
        }
        // 이미 읽은 공지는 readNoticeList에 유지하도록 수정
        if (!readNoticeList.includes(uid)) {
            readNoticeList.push(uid); // 읽은 것으로 처리
        }
    });

    localStorage.setItem('readNoticeList', JSON.stringify(readNoticeList));
    localStorage.setItem('selfDeletedNoticeList', JSON.stringify(selfDeletedNoticeList));

    // 리스트 갱신
    getNotices("#tab01");
}

// 알람 여부에 따라 공지사항 필터링하는 함수
function filterNoticesByAlarm(notices, alarmFilter) {
    if (alarmFilter === "Y") {
        return notices.filter(function(notice) {
            return notice.alarm_result !== null && notice.alarm_result !== '' && notice.alarm_result !== undefined;
        });
    } else if (alarmFilter === "N") {
        return notices.filter(function(notice) {
            return notice.alarm_result === null || notice.alarm_result === undefined || notice.alarm_result === '';
        });
    } else {
        return notices; // 알람 필터링이 없는 경우 모든 공지사항 반환
    }
}

// 필터링된 공지사항 데이터를 HTML에 추가하는 함수
// 본인이 작성한 공지사항만 버튼이 보이도록
// pulldelete로 삭제버튼을 눌렀을 때 실행되는 함수
function addFilteredNoticesToHTML(notices, categoryFilter) {
    let noticeList = $(".notice_list");
    noticeList.empty(); // 기존의 공지사항을 모두 지우고 시작

    // 입력된 공지 데이터의 uid 순서대로 리스트를 구성합니다.
    notices.forEach(function(notice) {
        // selfDeletedNoticeList에 있는 uid는 건너뜁니다.
        if (selfDeletedNoticeList.includes(notice.uid)) {
            return;
        }

        // 카테고리 필터 적용
        if (!categoryFilter || notice.category == categoryFilter) {
            // alarm_time을 formatDate 함수를 사용하여 원하는 형식으로 변환
            let formattedDate = notice.create_time == null ? "-" : formatDate(new Date(notice.create_time));

            // 이미 읽은 공지사항인 경우, 새로운 표시를 없앱니다.
            let isNewClass = readNoticeList.includes(notice.uid) ? '' : `<span class="new">N</span>`;

            let creatorName = notice.creator_name !== undefined ? notice.creator_name : "알 수 없음";
            let noticeItem = `
                <li class="pull_delete" data-uid="${notice.uid}">
                    <div>
                        <h4 class="btn_notice_view" id="${notice.uid}">${isNewClass} [공지] ${notice.title}</h4>
                        <p>
                            ${formattedDate} / ${creatorName} <!-- 변환된 날짜 표시 -->
                            <span class="func">
                                ${((notice.creator === window.localStorage.getItem("verifyUser")) && (window.localStorage.getItem("noticeRegPermitted") === true)) ? `
                                    <button class="btn btn_confirm_pop" type="button" name="" id="${notice.uid}"><i class="ri-send-plane-2-line"></i></button>
                                    <button class="btn btn_edit_notice" type="button" name="" id="${notice.uid}"><i class="ri-edit-2-line"></i></button>
                                    <button class="btn btn_delete_notice" type="button" name="" id="${notice.uid}"><i class="ri-delete-bin-line"></i></button>
                                ` : ''}
                            </span>
                        </p>
                    </div>
                </li>
            `;
            noticeList.append(noticeItem); // 생성한 공지사항 HTML을 리스트에 추가
        }
    });

    // pulldelete 이벤트 핸들러 추가
    $('.pull_delete').pulldelete(function($dom){
        let uid = $dom.data('uid');
        
        // 선택된 공지를 selfDeletedNoticeList에 추가하여 해당 공지를 삭제했음을 표시
        selfDeletedNoticeList.push(uid);
        readNoticeList.push(uid); 
        localStorage.setItem('selfDeletedNoticeList', JSON.stringify(selfDeletedNoticeList));
        localStorage.setItem('readNoticeList', JSON.stringify(readNoticeList));
        $dom.remove();
        updateNewNoticeIndicator();
    });
}

// 읽은 공지사항 처리하는 함수
function markReadNotices(notices) {
    $(".btn_notice_view").each(function() {
        let noticeUid = $(this).attr("id");
        if (notices.includes(noticeUid)) {
            // 읽은 공지사항이면서 새로운 표시가 있는 경우에만 제거하도록 수정
            if ($(this).find('.new').length > 0) {
                $(this).find('.new').remove();
            }
        }
    });
}

// 공지 검색 함수
function searchNotices(keyword) {
    // 각 공지사항을 순회하면서 검색어와 제목을 비교하여 일치하는 것만 보여줍니다.
    $('.notice_list li').each(function() {
        let noticeTitle = $(this).find('.btn_notice_view').text().toLowerCase(); // 공지 제목을 소문자로 가져옵니다.
        if (noticeTitle.indexOf(keyword) !== -1) {
            $(this).show(); // 검색어가 제목에 포함되어 있는 경우 해당 공지사항을 표시합니다.
        } else {
            $(this).hide(); // 검색어가 제목에 포함되어 있지 않은 경우 해당 공지사항을 숨깁니다.
        }
    });
}

// 이전에 보고 있던 탭을 다시 그리는 함수
function redrawLastVisitedTab() {
    let lastVisitedTabId = localStorage.getItem('lastVisitedTabId');
    if (lastVisitedTabId) {
        getNotices("#" + lastVisitedTabId);
    }
}

// 선택한 공지사항 불러오기 함수
function getSelectedNotice(selectedNoticeUid){
    let tempUrl = server_host + server_port + '/astroapi/notice/v1/notice/' + selectedNoticeUid;

    cordova.plugin.http.get(tempUrl, {}, {
        Authorization: 'Bearer ' + userData.astroToken
    }, function (response) {
        let jsonData = JSON.parse(response.data);
        console.log('getSelectedNotice',"jsonData.data : " + JSON.stringify(jsonData.data));
        
        let creatorName = jsonData.data.creator_name !== undefined ? jsonData.data.creator_name : "알 수 없음";
        let deptName = jsonData.data.dept_name !== "" ? jsonData.data.dept_name : "알 수 없음";

        // JSON 데이터를 활용하여 HTML 수정
        let noticeHtml = `
            <div class="head" style="-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none">
                <h4>[공지] ${jsonData.data.title}</h4>
                <p>작성자 : ${deptName} / ${creatorName}</p>
                <p>작성일 : ${formatDate(jsonData.data.create_time)}</p>
            </div>
            <div class="cont">
                ${jsonData.data.contents}
            </div>
            <div class="btn_box" style="-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none">
            ${((jsonData.data.creator === window.localStorage.getItem("verifyUser")) && (window.localStorage.getItem("noticeRegPermitted") === true))  ? '<a href="javascript:" class="notice_forward" data-uid="'+selectedNoticeUid+'">재전송</a>' : ''}
                <a href="#" class="notice_view_close">닫기</a>
            </div>
        `;
        $('.notice_pop_close').hide();
        // HTML을 공지사항 컨테이너에 추가
        $("#notice_container").html(noticeHtml);

        // 현재 탭의 ID 저장
        let currentTabId = $(".tab-content .tab-pane.active").attr("id");
        localStorage.setItem('lastVisitedTabId', currentTabId);

        if (!readNoticeList.includes(jsonData.data.uid)) {
            readNoticeList.push(jsonData.data.uid);
            // localStorage에 업데이트된 readNoticeList 저장
            localStorage.setItem('readNoticeList', JSON.stringify(readNoticeList));
        }
        
    }, function (response) {
        console.log('getSelectedNotice',"공지사항 불러오기 실패 response status:" + JSON.stringify(response));
        console.log('getSelectedNotice',response.error);
        popAlert("오류가 발생했습니다.<br/>잠시 후 다시 시도해 주세요");
    });
}

function editSelectedNotice(selectedNoticeUid){
    let tempUrl = server_host + server_port + '/astroapi/notice/v1/notice/' + selectedNoticeUid;

    cordova.plugin.http.get(tempUrl, {}, {
        Authorization: 'Bearer ' + userData.astroToken
    }, function (response) {
        let jsonData = JSON.parse(response.data);
        console.log('editSelectedNotice',"jsonData.data : " + JSON.stringify(jsonData.data));
        console.log('editSelectedNotice',selectedNoticeUid);

        $("#notice_edit_submit").text("수정");

        let deptCodes = jsonData.data.trgt_dept_codes.split(',');
        let deptNames = jsonData.data.trgt_dept_names.split(',');

        // 입력사항 초기화
        $("#notice_title").val(jsonData.data.title);
        $("#editor_main").summernote('code', jsonData.data.contents);
        $("input[name='category'][value='" + jsonData.data.category + "']").prop('checked', true);
        jsonData.data.start_time == null ? $("#selected_period").text("") : $("#selected_period").text(formatDate(jsonData.data.start_time) + " ~ " + formatDate(jsonData.data.end_time));
        $("input[name='target'][value='" + jsonData.data.trgt + "']").prop('checked', true).trigger('change');
        jsonData.data.start_time == null ? $("#unlimited").prop("checked", true).trigger("change") : $("#unlimited").prop("checked", false).trigger("change");
        target_dept_codes = jsonData.data.trgt == 'DEPT' ? deptCodes : [];
        target_dept_names = jsonData.data.trgt == 'DEPT' ? deptNames : [];

        if (jsonData.data.trgt == 'DEPT') {
            $("#selected_depts").empty(); // 선택한 부서 항목을 초기화합니다.
            deptNames.forEach(function(deptName) {
                let newListItem = $("<div class='swiper-slide'>" + deptName.trim() + " <a href='#' class='del'></a></div>");
                $(".picks.swiper-wrapper").append(newListItem);
            });
        } else {
            // DEPT가 아닌 경우에는 선택한 부서 항목을 숨깁니다.
            $("#selected_depts").empty(); // 선택한 부서 항목을 초기화합니다.
        }

        $(".notice_edit").stop().show();
        $(".notice_view").stop().hide();
        
    }, function (response) {
        console.log('editSelectedNotice',"공지사항 불러오기 실패 response status:" + JSON.stringify(response));
        console.log('editSelectedNotice',response.error);
        popAlert("오류가 발생했습니다.<br/>잠시 후 다시 시도해 주세요");
    });
};

// 공지사항 등록
function addNotice() {

    let dataSerializer = cordova.plugin.http.getDataSerializer();

    cordova.plugin.http.setDataSerializer('json');

    // 필요한 데이터를 HTML에서 가져오기
    let title = document.getElementById("notice_title").value;
    let contents = $("#editor_main").val();
    let startDate = $("#notice_start_date").val();
    let startTime = $("#notice_start_time").val();
    let endDate = $("#notice_end_date").val();
    let endTime = $("#notice_end_time").val();
    let category = $("input[name='category']:checked").val();
    let target = $("input[name='target']:checked").val();

    if(!$("#unlimited").is(":checked")){

        //공지사항 기본 유지일수 설정
        let def_remains = 0;

        try {
            def_remains = parseInt(settingData.notice_def_remains);
        } catch (error) {
            def_remains = 0;
        }
        
        if(startDate == '' && startTime == '' && endDate == '' && endTime == ''){
            let today = new Date(), sday = new Date(), eday = new Date(today.setDate(today.getDate() + def_remains)),y,M,d;

            y = sday.getFullYear().toString();
            M = (sday.getMonth()+1).toString();
            if(M.length == 1){ M = '0'+M; }
            d = sday.getDate().toString();
            if(d.length == 1){ d = '0'+d; }
            
            startDate = y+'.'+M+'.'+d;
            startTime = '00:00';

            y = eday.getFullYear().toString();
            M = (eday.getMonth()+1).toString();
            if(M.length == 1){ M = '0'+M; }
            d = eday.getDate().toString();
            if(d.length == 1){ d = '0'+d; }

            endDate = y+'.'+M+'.'+d;
            endTime = '23:59'

        }else if((startDate == '' && startTime != '') || (endDate == '' && endTime != '')){
            return popAlert('공지 기간을 정확히\n입력해주세요.');
        }else{
            if(startDate != '' && startTime == ''){
                startTime = '00:00';
            }

            if(endDate != '' && endTime == ''){
                endTime = '23:59';
            }
        }
    }

     // 시작일과 종료일이 유효한 값인지 확인하고 ISO 형식의 문자열로 변환
     let formattedStartTime = startDate && startTime ? formatDateTime(startDate, startTime) : null;
     let formattedEndTime = endDate && endTime ? formatDateTime(endDate, endTime) : null;

    // 데이터 객체 구성
    let data = {
        corp_code: serverData.corp_code,
        category: category,
        title: title,
        contents: contents,
        start_time: formattedStartTime,
        end_time: formattedEndTime,
        temp: 0,
        alarm_time: "",
        trgt: target,
        trgt_dept_codes: $("input[name='target']:checked").val() == 'DEPT' ? target_dept_codes.join(',') : "",
        trgt_dept_names: $("input[name='target']:checked").val() == 'DEPT' ? target_dept_names.join(',') : "",
    };

    if((title == "") || (contents == "")){
        return popAlert("입력사항을\n정확히 입력해주세요.");
    };

    if ((((startDate == "") || (startTime == "") || (endDate == "") || (endTime == "")) || ((startDate == undefined) || (startTime == undefined) || (endDate == undefined) || (endTime == undefined))) && ($("#unlimited").is(":checked") == false)){
        return popAlert("기간을\n정확히 입력해주세요.");
    };
    
    if (selectedNoticeUid == "") {
        let tempUrl = server_host + server_port + '/astroapi/notice/v1/notice';

        cordova.plugin.http.post(tempUrl, data, {
            Authorization: 'Bearer ' + userData.astroToken
        }, function(response) {
            let jsonData = JSON.parse(response.data);

            // 성공 시 작업
            getNotices("#tab01");
            $("#span_new_notice").addClass("new");
            $(".notice_edit").stop().hide();
            popConfirm("등록되었습니다.\n알림을 발송하시겠습니까?", function(){
                let storedNoticeId = jsonData.data.uid;
                sendNoticeAlert(storedNoticeId);
            });
        }, function(response) {
            console.log('addNotice',"등록 실패 : " + response);
            popAlert(response.error);
        });
    } else {
        let tempUrl = server_host + server_port + '/astroapi/notice/v1/notice/' + selectedNoticeUid;

        console.log('addNotice',"파라미터 잘 들어가는지 확인용 : " + JSON.stringify(data));
        cordova.plugin.http.put(tempUrl, data, {
            Authorization: 'Bearer ' + userData.astroToken
        }, function(response) {
            console.log('addNotice',"post 되긴하고 있는거임??" + response.data);
            // 성공 시 작업
            getNotices("#tab01");
            $(".notice_edit").stop().hide();
            popAlert("수정되었습니다.");
            target_dept_codes = [];
            target_dept_names = [];
        }, function(response) {
            console.log('addNotice',"수정 실패 : " + JSON.stringify(response.data));
            popAlert("오류가 발생했습니다.<br/>잠시 후 다시 시도해 주세요");
        });
    }
    cordova.plugin.http.setDataSerializer(dataSerializer);
};

function deleteNotice(selectedNoticeUid){
    let dataSerializer = cordova.plugin.http.getDataSerializer();

    cordova.plugin.http.setDataSerializer('utf8');

    let tempUrl = server_host + server_port + '/astroapi/notice/v1/notice/' + selectedNoticeUid;

    cordova.plugin.http.delete(tempUrl, {}, {
        Authorization: 'Bearer ' + userData.astroToken
    }, function (response) {

        popAlert("삭제되었습니다.");

        getNotices();

    }, function (response) {
        console.log('deleteNotice',"공지사항 삭제 실패 response status:" + JSON.stringify(response));
        console.log('deleteNotice',response.error);
        popAlert("오류가 발생했습니다.<br/>잠시 후 다시 시도해 주세요");
    });
    cordova.plugin.http.setDataSerializer(dataSerializer);
};

function readNotice(selectedNoticeUid) {
    let dataSerializer = cordova.plugin.http.getDataSerializer();

    cordova.plugin.http.setDataSerializer('json');

    let tempUrl = server_host + server_port + '/astroapi/notice/v1/notice/read';

    let data = {
        notice_uid: selectedNoticeUid
    };

    cordova.plugin.http.put(tempUrl, data, {
        Authorization: 'Bearer ' + userData.astroToken
    }, function(response) {
        let jsonData = JSON.parse(response.data);
        console.log('readNotice',"jsonData.data : " + JSON.stringify(jsonData.data));
        popAlert("읽음 처리 되었습니다.");

    }, function(response) {
        console.log('readNotice',"공지사항 불러오기 실패 response status:" + JSON.stringify(response));
        console.log('readNotice',response.error);
        popAlert("오류가 발생했습니다.<br/>잠시 후 다시 시도해 주세요");
    });

    cordova.plugin.http.setDataSerializer(dataSerializer);
}

// 공지사항 알림 발송
function sendNoticeAlert(storedNoticeId){
    let dataSerializer = cordova.plugin.http.getDataSerializer();

    cordova.plugin.http.setDataSerializer('json');

    let tempUrl = server_host + server_port + '/astroapi/mdial/v1/notice/alarm/send';

    console.log('sendNoticeAlert',"sendNotice : " + storedNoticeId);
    
    let data = {
        notice_id : storedNoticeId
    }

    console.log('sendNoticeAlert',data);

    cordova.plugin.http.post(tempUrl, data, {
        Authorization: 'Bearer ' + userData.astroToken
    }, function (response) {
        let jsonData = JSON.parse(response.data);
        console.log('sendNoticeAlert',"jsonData.data : " + JSON.stringify(jsonData));
        popAlert("발송되었습니다.")
    }, function (response) {
        console.log('sendNoticeAlert',"공지사항 발송 실패 response status:" + JSON.stringify(response));
        console.log('sendNoticeAlert',response.error);
        popAlert("오류가 발생했습니다.<br/>잠시 후 다시 시도해 주세요");
    });

    cordova.plugin.http.setDataSerializer(dataSerializer);
};



//////---------- FUNCTION DEFINE END


$(()=>{

    //공지 제외조직에 속한 사용자가 로그인시에는 공지사항 경조사만 볼 수있음
    try {
        if((settingData.noticeManageGroups.split(",")).includes(settingData.deptCode)) {
            $(".notice_pop").stop().show();
            getNotices("#tab02");
            let noticeRegPermitted = window.localStorage.getItem("noticeRegPermitted");
            if (noticeRegPermitted === "false") {
                $(".btn_notice_edit").stop().hide();
                $("#alarmSelect").stop().hide();
            } else {
                $(".btn_notice_edit").stop().show();
                $("#alarmSelect").stop().show();
            }
            $(".notice_pop_close").stop().hide();

            $("#tab_notice li a[href='#tab02']").click();
            $("#tab_notice li a[href='#tab01']").parent().hide();
            $("#tab_notice li a[href='#tab03']").parent().css("visibility",'hidden');
        }
    } catch (error) {
        
    }

    // 페이지가 로드될 때 읽은 공지사항 표시
    markReadNotices(readNoticeList);

    // 알람 셀렉트 박스 변경 이벤트 핸들러
    $("#alarmSelect").change(function() {
        // 현재 활성화된 탭의 링크를 선택
        let currentTabLink = $(".tabnav li a.active");
        
        // 해당 링크의 href 값을 가져와서 클릭 이벤트를 트리거
        let currentTabHref = currentTabLink.attr("href");
        $('a[href="' + currentTabHref + '"]').trigger("click");
    });

    // 탭 변경 이벤트 핸들러
    $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
        let selectedTabId = $(e.target).attr('href'); // 선택된 탭의 ID 가져오기
        getNotices(selectedTabId); // 해당 탭에 대한 공지사항 조회
    });

    // 공지사항 알림 발송 버튼 클릭 이벤트 핸들러 추가
    $(".btn_confirm_pop").click(function(){
        let selectedNoticeUid = $(this).closest("li").find(".btn_notice_view").attr("id");
        $(".btn_submit.sendNotice").data("notice-id", selectedNoticeUid); // 발송 버튼에 선택된 공지사항 ID 저장
        $(".confirm_pop").show(); // 확인 팝업 열기
    });

    $(".btn_edit_notice").click(function(){
        let selectedNoticeUid = $(this).closest("li").find(".btn_notice_view").attr("id");
        editSelectedNotice(selectedNoticeUid);
    });

    // 공지사항 삭제 버튼 클릭 이벤트 핸들러 추가
    $(".btn_delete_notice").click(function(){
        let selectedNoticeUid = $(this).closest("li").find(".btn_notice_view").attr("id");

        popConfirm('삭제하시겠습니까?\n삭제한 데이터는 복구 할 수 없습니다.', function(){
            deleteNotice(selectedNoticeUid); // 선택된 공지사항 삭제 함수 호출
        })
    });

    // 모두읽음 버튼 클릭 이벤트 핸들러
    $("#readAllNotice").on("click", function(e){
        e.preventDefault();
        e.stopPropagation();
        readAllNotices();
    });

    // 모두삭제 버튼 클릭 이벤트 핸들러
    $("#deleteAllNotice").on("click", function(e){
        e.preventDefault();
        e.stopPropagation();
        popConfirm("공지 사항을\n모두 삭제하시겠습니까?", function(){
            deleteAllNotices();
        });
    });

    // 알람 셀렉트 박스 변경 이벤트 핸들러
    $("#alarmSelect").change(function() {
        // 현재 활성화된 탭의 링크를 선택
        let currentTabLink = $(".tabnav li a.active");
        
        // 해당 링크의 href 값을 가져와서 클릭 이벤트를 트리거
        let currentTabHref = currentTabLink.attr("href");
        $('a[href="' + currentTabHref + '"]').trigger("click");
    });

    $('.tab_wrap .tabcontent > div').hide();
    
    //공지사항 탭선택
    $("#tab_notice a").click(function(e){
        e.preventDefault();
        let tabId = $(this).attr("href");

        $('.tab_wrap .tabcontent > div').hide().filter(this.hash).fadeIn();
        $('.tab_wrap .tabnav a').removeClass('active');
        $(this).addClass('active');

        getNotices(tabId); // 각 탭에 해당하는 데이터를 요청
    });

    $(".notice_pop .popup_close").click(function(e){
        e.preventDefault();
        //getNoticesUids();
        $(".notice_pop").stop().hide();
    });

    // 공지 발송 확인 팝업 - 확인 버튼 클릭 시
    $(".btn_submit.sendNotice").click(function(e){
        e.preventDefault();
        // let selectedNoticeUid = $(this).closest("li").find(".btn_notice_view").attr("id"); // 선택된 공지사항 ID 가져오기
        let storedNoticeId = $(".btn_submit.sendNotice").data("notice-id");
        sendNoticeAlert(storedNoticeId); // 공지사항 알림 발송 함수 호출
        $(".confirm_pop").stop().hide(); // 확인 팝업 닫기
    });

    // 공지 발송 확인 팝업 - 취소 버튼 클릭 시
    $(".confirm_pop_close").click(function (e) {
        e.preventDefault();
        $(".confirm_pop").stop().hide(); // 확인 팝업 닫기
    });

    // 이벤트 위임을 사용하여 .btn_notice_view 요소 클릭 이벤트 처리
    $('ul.notice_list').on("click", "li", function(e){
        e.preventDefault();
        let selectedNoticeUid = $(this).find('.btn_notice_view').attr("id");
        getSelectedNotice(selectedNoticeUid);
        $(".notice_view").stop().show();
    });
    // 버튼 클릭 시 이벤트 전파 중단
    $('ul.notice_list').on("click", ".func button", function(e){
        e.preventDefault();
        e.stopPropagation();
    });


    // 전달 버튼으로 알림 발송
    $('.notice_pop').on("click", ".notice_forward", function(e){
        e.preventDefault();
        // alert(selectedNoticeUid);
        sendNoticeAlert($(this).data('uid'));
    });

    // 이벤트 위임을 사용하여 .notice_view_close 요소 클릭 이벤트 처리
    $('.notice_pop').on("click", ".notice_view_close", function(e){
        e.preventDefault();
        $(".notice_view").stop().hide();
        $(".notice_view").empty();
        $('.notice_pop_close').show();
        selectedNoticeUid = "";

        // 이전에 보고 있던 탭을 다시 그림
        redrawLastVisitedTab();
    });

    //공지등록 
    $(".btn_notice_edit").click(function(e){
        e.preventDefault();
        
        // 입력사항 초기화
        selectedNoticeUid = "";
        $("#notice_edit_submit").text("등록");
        $("#notice_title").val("");
        $("#editor_main").summernote('reset');
        $("input[name='category'][value='E']").prop('checked', true).trigger("change");
        $("#notice_start_date").val("");
        $("#notice_start_time").val("");
        $("#notice_end_date").val("");
        $("#notice_end_time").val("");
        $("#selected_period").text("");
        $("input[name='target'][value='ALL']").prop('checked', true).trigger("change");
        $("#unlimited").prop("checked", true).trigger("change")
        target_dept_codes = [];
        target_dept_names = [];
        $("#selected_depts").empty();

        $(".notice_edit").stop().show();
        $(".notice_view").stop().hide();
    });

    //공지등록 취소
    $(".notice_edit_close").click(function(e){
        e.preventDefault();
        $(".notice_edit").stop().hide();
        selectedNoticeUid = "";
    });

    //부서검색 팝업
    $(".btn_organ_pop").click(function (e) {
        e.preventDefault();
        $(".organ_pop").stop().show();
    });
    $(".organ_pop_close").click(function (e) {
        e.preventDefault();
        $(".organ_pop").stop().hide();
    });

    // 부서 선택 클릭 시 
    $(".btn_submit.choose_dept").click(function(e){
        e.preventDefault();
        if (selected_dept_code !== undefined) { 
            target_dept_codes.push(selected_dept_code);
            console.log('.btn_submit.choose_dept onclick',"target_dept_codes : " + target_dept_codes);
        }
        if (selected_dept_name !== undefined) { 
            target_dept_names.push(selected_dept_name);
            console.log('.btn_submit.choose_dept onclick',"target_dept_names : " + target_dept_names);

            let newListItem = $("<div class='swiper-slide'>" + selected_dept_name + " <a href='#' class='del'></a></div>");
            $(".picks.swiper-wrapper").append(newListItem);
        }
        $(".organ_pop").stop().hide();
    });

    // 선택한 부서 취소
    $("#selected_depts").on("click", "a.del", function(e) {
        e.preventDefault();

        let deptItem = $(this).parent();
        let deptName = deptItem.text().trim();

        let index = target_dept_names.indexOf(deptName);
        if (index !== -1) {
            target_dept_names.splice(index, 1);
            target_dept_codes.splice(index, 1);
        }

        deptItem.remove();
    });

    // 공지 기간 설정 팝업 열기
    $(".btn_term_pop").click(function(e){
        e.preventDefault();
        $(".term_pop").stop().show();
    });

    $(".btn_close.term_pop_close").click(function(e){
        e.preventDefault();
        $(".term_pop").stop().hide();
    });

    // 기간 설정 팝업에서 확인 버튼 클릭 시
    $(".btn_submit.setTime").click(function (e) {
        e.preventDefault();

        let selectedTime; // 변수 선언

        if ($("#unlimited").prop("checked")) {
            selectedTime = null; // 체크박스가 체크되었을 때 null 할당
            $("#selected_period").text("");
        } else {
            // 시작일과 종료일을 가져와서 기간에 넣기
            let startDate = $("#notice_start_date").val();
            let startTime = $("#notice_start_time").val();
            let endDate = $("#notice_end_date").val();
            let endTime = $("#notice_end_time").val();

            // 선택한 시간을 기간에 삽입
            selectedTime = startDate + " " + startTime + " ~ " + endDate + " " + endTime;
        }

        console.log('btn_submit.setTime on click',selectedTime);

        // 선택한 시간을 #selected_period 레이블에 표시
        selectedTime == null || selectedTime == "  ~  " ? "" : $("#selected_period").text(selectedTime);

        // 팝업 닫기
        $(".term_pop").stop().hide();
    });

    // 공지사항 등록 버튼 클릭 시
    $("#notice_edit_submit").click(function(e){
        e.preventDefault();
        addNotice();
    });

    $('.notice_pop').on("click", ".pd_btn", function() {
        // 클릭된 pd_btn의 부모 요소(li)에서 id 값을 가져옴
        let selectedNoticeUid = $(this).closest("li").find(".btn_notice_view").attr("id");
        readNotice(selectedNoticeUid); // readNotice 함수 호출
    });

    //공지기간 제한없음
    $("#unlimited").on("change", function () {
        if ($(this).is(":checked")) {
            // Disable date/time inputs
            $("#notice_start_date").prop('disabled', true);
            $("#notice_start_time").prop('disabled', true);
            $("#notice_end_date").prop('disabled', true);
            $("#notice_end_time").prop('disabled', true);
        } else {
            // Enable date/time inputs
            $("#notice_start_date").prop('disabled', false);
            $("#notice_start_time").prop('disabled', false);
            $("#notice_end_date").prop('disabled', false);
            $("#notice_end_time").prop('disabled', false);
        }
    });

    // 공지 검색 기능 구현
    $('#notice_srch_keyword').on('keyup', function() {
        let searchKeyword = $(this).val().toLowerCase().trim(); // 검색어를 소문자로 변환하여 가져옵니다.
        searchNotices(searchKeyword); // 검색어를 이용하여 공지사항을 검색합니다.
    });

    //공지사항진입 아이콘 숨기기/보여주기
    if(settingData.notice_used == 'Y'){
        $('#loadNoticesBtn').show();
    } else {
        $('#loadNoticesBtn').hide();
    }
    getNoticesUids();

    //공지사항 팝업
    $(".btn_notice").click(function(e){
        e.preventDefault();
        let noticeRegPermitted = window.localStorage.getItem("noticeRegPermitted");
        getNotices();
        if (noticeRegPermitted === "false") {
            $(".func").stop().hide();
            $(".btn_notice_edit").stop().hide();
            $("#alarmSelect").stop().hide();
            
        } else {
            $(".btn_notice_edit").stop().show();
            $("#alarmSelect").stop().show();
        }
        getNotices("#tab01");
        $(".notice_pop").stop().show();
    });
});